on run(argv)
    -- 参数检查
    if (count of argv) = 0 then
        error "未提供参数"
    end if

    set appPath to item 1 of argv
    set appName to "unknown"

    -- 识别应用类型
    if appPath contains "iopro" then
        set appName to "iO Pro"
    else if appPath contains "io" then
        set appName to "iO"
    else if appPath contains "pd4" then
        set appName to "ProDriver"
    else if appPath contains "fxplay" then
        set appName to "FX-Play"
    end if

    -- 检查应用是否已安装
    set targetAppPath to "/Applications/" & appName & ".app"
    tell application "System Events"
        if exists file targetAppPath then
            set dialogResult to display dialog appName & " is ready! Launch it?" buttons {"Yes", "No"} default button "Yes"
            if button returned of dialogResult is "Yes" then
                do shell script "open " & quoted form of targetAppPath
            end if
            return "app found"
        else
            return "app not found:" & appName
        end if
    end tell
end run
